package petShop;

import java.util.ArrayList;
import java.util.Scanner;

public class Invoice {
    ArrayList<Item> items = new ArrayList<Item>();

    public void add(Item anItem){
        items.add(anItem);
    }

    public double getDiscount(){
        boolean isPet = false;
        double petPrice = 0;
        double otherPrice = 0;
        int totalQuantity = 0;
        for (Item e : items) {
            if (e.isPet) {
                isPet = true;
                petPrice += e.price * e.quantity;
            } else {
                otherPrice += e.price * e.quantity;
                totalQuantity += e.quantity;
            }
        }

        if (isPet && totalQuantity >= 5){
            return petPrice + 0.80 * otherPrice;
        } else {
            return petPrice + otherPrice;
        }
    }

    public static void main(String[] args) {
        Invoice invoice = new Invoice();

        Scanner sc = new Scanner(System.in);

        boolean done = false;

        while (!done)
        {
            double prix;
            int quantite;
            boolean isPet;
            System.out.print("Entrez le prix de l'article : ");
            prix = sc.nextDouble();
            System.out.print("Entrez la quantité d'articles : ");
            quantite = sc.nextInt();
            System.out.println("Est-ce un animal ? 0-oui 1-non");
            isPet = sc.nextInt() == 1;
            System.out.println("Avez-vous d'autre articles ? 0-oui 1-non");
            done = sc.nextInt() == 1;
            
            // Ajoute l'item
            invoice.add(new Item(prix, isPet, quantite));
        }

        System.out.println("invoice.getDiscount() = " + invoice.getDiscount());
    }
}
